<?php
header('Content-Type: text/html; charset=utf-8');
include '../include/session.php';
include '../../include/conn.php';

if (isset($_GET['leave_log_id']))
{
    date_default_timezone_set('Asia/Bangkok');
    $now = date('Y-m-d H:i:s');
    $conn = $pdo->open();
    $date_period = date('Y-m-d 00:00:00');

    try
    {
        $stmt = $conn->prepare("UPDATE leave_log SET 
                leave_log_approve_status=:leave_log_approve_status,
                leave_log_update_by=:leave_log_update_by,
                leave_log_update_date=:leave_log_update_date,
                leave_log_transection_lock=:leave_log_transection_lock,
                leave_log_approve_by=:leave_log_approve_by
                 WHERE leave_log_id=:leave_log_id");
        $stmt->execute([

        'leave_log_approve_status' => $_GET['leave_log_approve_status'], 
        'leave_log_update_by' => $_SESSION['user_name'], 
        'leave_log_update_date' => $now, 
        'leave_log_id' => $_GET['leave_log_id'], 
        'leave_log_approve_by' => $_SESSION['user_name'], 
        'leave_log_transection_lock' => 1

        ]);
        echo $_SESSION['success'] = $_GET['session_value'];

    }
    catch(PDOException $e)
    {
        $_SESSION['error'] = $e->getMessage();
    }

    if ($_GET['leave_log_approve_status'] == 1)
    {

        try
        {
            $stmt = $conn->prepare("
               SELECT
  leave_log.leave_log_id, 
  leave_log.leave_log_leave_id, 
  leave_log.leave_log_user_id, 
  leave_log.leave_log_approve_status, 
  leave_log.leave_log_approve_by, 
  leave_log.leave_log_from_date, 
  leave_log.leave_log_to_date,
  leave_log.leave_log_add_by,
  leave_log.leave_log_add_date,
  `leave`.leave_name,
  leave_log.leave_log_request_leave_no,
  leave_log.leave_log_remark,
  `user`.user_name,
  `user`.user_nick_name,
  depart.depart_name
FROM
  leave_log
  LEFT JOIN `leave` ON leave_log.leave_log_leave_id = `leave`.leave_id
  LEFT JOIN `user` ON leave_log.leave_log_user_id = `user`.user_id
  LEFT JOIN depart ON `user`.user_depart_id = depart.depart_id
WHERE
  leave_log.leave_log_id  LIKE CONCAT ('%',:leave_log_id,'%')
ORDER BY leave_log_add_date desc



                ");
            $stmt->execute(['leave_log_id' => $_GET['leave_log_id']]);
            foreach ($stmt as $row)
            {
                $user_name = $row['user_name'];
                $leave_log_from_date = date("d-m-Y", strtotime($row['leave_log_from_date']));
                $leave_log_to_date = date("d-m-Y", strtotime($row['leave_log_to_date']));
                $leave_name = $row['leave_name'];
                $leave_log_remark = $row['leave_log_remark'];
                $user_nick_name = $row['user_nick_name'];
                $depart_name = $row['depart_name'];
                $leave_log_user_id = $row['leave_log_user_id'];
                $leave_log_id = $row['leave_log_id'];
                $leave_log_leave_id = $row['leave_log_leave_id'];

            }
        }
        catch(PDOException $e)
        {
            $_SESSION['error'] = $e->getMessage();
        }

        $date_period = date('Y-m-d 00:00:00');

        $begin = new DateTime($leave_log_from_date);
        $end = new DateTime($leave_log_to_date);

        for ($i = $begin;$i <= $end;$i->modify('+1 day'))
        {

            try
            {
                $stmt = $conn->prepare("
                    INSERT INTO worktime 
                    (worktime_user_id, 
                    worktime_work_type_id,
                    worktime_leave_id,
                    worktime_leave_from_date,
                    worktime_add_date,
                    worktime_add_by,
                    worktime_date,
                    worktime_leave_log_id,
                    worktime_active
                    ) 
                    VALUES 
                    (:worktime_user_id,
                    :worktime_work_type_id,
                    :worktime_leave_id,
                    :worktime_leave_from_date,
                    :worktime_add_date,
                    :worktime_add_by,
                    :worktime_date,
                    :worktime_leave_log_id,
                    :worktime_active
                )");
                $stmt->execute([
                    'worktime_user_id' => $leave_log_user_id, 
                    'worktime_work_type_id' => 2, 
                    'worktime_leave_id' => $leave_log_leave_id, 
                    'worktime_leave_from_date' => $i->format("Y-m-d") , 
                    'worktime_add_date' => $now, 
                    'worktime_add_by' => $_SESSION['user_name'],
                    'worktime_date' => $i->format("Y-m-d"),
                    'worktime_leave_log_id' => $_GET['leave_log_id'],
                    'worktime_active' => 1
                     ]);
                $_SESSION['success'] = 'อนุมัติสำเร็จ';

                $last_id = $conn->lastInsertId();
            }
            catch(PDOException $e)
            {
                $_SESSION['error'] = $e->getMessage();
            }

        }


        $sMessage = "\n".'แจ้งอนุมัติการลา'."\n".$user_name."/".$user_nick_name."\n".'แผนก '.$depart_name. "\n" . 'ประเภท ' . $leave_name ."\n".'วันที่ '.$leave_log_from_date."\n".' ถึง '.$leave_log_to_date."\n".'หมายเหตุ '.$leave_log_remark."\n".'ผู้บริหารอนุมัติแล้ว ';


    $conn = $pdo->open();
    try
    {
        $stmt = $conn->prepare("
                SELECT
                    alert.alert_id, 
                    alert.alert_token
                FROM
                    alert
                WHERE  
                    alert_id = :alert_id



                ");
        $stmt->execute(['alert_id' => 4]);
        foreach ($stmt as $row)
        {
            $sToken = $row['alert_token'];
        }
    }
    catch(PDOException $e)
    {
        $_SESSION['error'] = $e->getMessage();
    }

    include '../../include/line_notify.php';



     $conn = $pdo->open();
    try
    {
        $stmt = $conn->prepare("
                SELECT
                    alert.alert_id, 
                    alert.alert_token
                FROM
                    alert
                WHERE  
                    alert_id = :alert_id



                ");
        $stmt->execute(['alert_id' => 8]);
        foreach ($stmt as $row)
        {
            $sToken = $row['alert_token'];
        }
    }
    catch(PDOException $e)
    {
        $_SESSION['error'] = $e->getMessage();
    }

    include '../../include/line_notify.php';


    }

    $pdo->close();
}
else
{
    $_SESSION['error'] = 'ผิดพลาด';
}

header('location: leave.php');

?>
